#include "stdafx.h"
#include "CLS_NsLook_Interface.h"

HINSTANCE CLS_NsLook_Interface::s_hInstance  = NULL;
CString CLS_NsLook_Interface::s_strFilePath = _T("");

extern CString g_strInstDir;

IMPLEMENT_FUNCTION(NSLook_Startup);
IMPLEMENT_FUNCTION(NSLook_Cleanup);
IMPLEMENT_FUNCTION(NSLook_LogonServer);
IMPLEMENT_FUNCTION(NSLook_LogoffServer);
IMPLEMENT_FUNCTION(NSLook_Query);
IMPLEMENT_FUNCTION(NSLook_GetCount);
IMPLEMENT_FUNCTION(NSLook_GetList);
IMPLEMENT_FUNCTION(NSLook_ConnectNVS);

bool CLS_NsLook_Interface::LoadDLL()
{
	if(s_strFilePath.Compare(_T("")) == 0)
	{
		s_strFilePath = g_strInstDir + _T("nslook.dll");
	}
	s_hInstance = LoadLibrary(s_strFilePath.Trim());
	if(!s_hInstance) return false;

	EXPORT_FUNCTION(s_hInstance,NSLook_Startup);
	EXPORT_FUNCTION(s_hInstance,NSLook_Cleanup);
	EXPORT_FUNCTION(s_hInstance,NSLook_LogonServer);
	EXPORT_FUNCTION(s_hInstance,NSLook_LogoffServer);
	EXPORT_FUNCTION(s_hInstance,NSLook_Query);
	EXPORT_FUNCTION(s_hInstance,NSLook_GetCount);
	EXPORT_FUNCTION(s_hInstance,NSLook_GetList);
	EXPORT_FUNCTION(s_hInstance,NSLook_ConnectNVS);

	return true;
}

void CLS_NsLook_Interface::FreeDLL()
{
	if(s_hInstance)
	{
		::FreeLibrary(s_hInstance);
		s_hInstance = NULL;
	}
}
